from django import template

register = template.Library()

@register.filter
def bangla_number(value):
    try:
        num_map = {
            '0': '০', '1': '১', '2': '২', '3': '৩', '4': '৪',
            '5': '৫', '6': '৬', '7': '৭', '8': '৮', '9': '৯'
        }
        bangla_num = str(value)
        for k, v in num_map.items():
            bangla_num = bangla_num.replace(k, v)
        return bangla_num
    except (ValueError, TypeError):
        return value

@register.filter
def div(value, arg):
    """
    Divides the value by the argument.
    Usage: {{ value|div:arg }}
    """
    try:
        return int(value) / int(arg)
    except (ValueError, TypeError, ZeroDivisionError):
        return None

@register.filter
def mod(value, arg):
    """
    Calculates the remainder when value is divided by the argument.
    Usage: {{ value|mod:arg }}
    """
    try:
        return int(value) % int(arg)
    except (ValueError, TypeError, ZeroDivisionError):
        return None