# Generated by Django 5.2.1 on 2025-06-29 07:08

import django.db.models.deletion
import uuid
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('app', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AnnualSubscriptionDetails',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('price', models.IntegerField(blank=True, default=0, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='subscription/annual_img')),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('subject', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='annual_subscription_subjects', to='app.subject')),
            ],
        ),
        migrations.CreateModel(
            name='AnnualSubscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('start_date', models.DateField(auto_now_add=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('student', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='annual_subscriptions', to='app.studentprofile')),
                ('annual_subscription_details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='subscription.annualsubscriptiondetails')),
            ],
        ),
        migrations.CreateModel(
            name='AnnualSubscriptionkeys',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('key', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='keys', to='subscription.annualsubscriptiondetails')),
            ],
        ),
        migrations.CreateModel(
            name='BundleSubscriptionDetails',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('description', models.TextField(blank=True, default='', null=True)),
                ('price', models.IntegerField(blank=True, default=0, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='subscription/bundle_img')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('subjects', models.ManyToManyField(blank=True, related_name='bundle_subscription_details', to='app.subject')),
            ],
        ),
        migrations.CreateModel(
            name='BundleSubscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('start_date', models.DateField(auto_now_add=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app.classlevel')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundle_subscriptions', to='app.studentprofile')),
                ('subjects', models.ManyToManyField(related_name='bundle_subscriptions', to='app.subject')),
                ('bundle_subscription_details', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='bundle_subscriptions', to='subscription.bundlesubscriptiondetails')),
            ],
            options={
                'ordering': ['-start_date'],
            },
        ),
        migrations.CreateModel(
            name='SubjectBasedSubscriptionDetails',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('title', models.CharField(blank=True, default='', max_length=255, null=True)),
                ('description', models.TextField(blank=True, default='', null=True)),
                ('price', models.IntegerField(blank=True, default=0, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to='subscription/subject_img')),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('subject', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subject_based_subscription_subjects', to='app.subject')),
            ],
        ),
        migrations.CreateModel(
            name='SubjectBasedSubscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('start_date', models.DateField(auto_now_add=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('class_level', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='app.classlevel')),
                ('student', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subject_subscriptions', to='app.studentprofile')),
                ('subjects', models.ManyToManyField(blank=True, to='app.subject')),
                ('subject_based_subscription_details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='subscription.subjectbasedsubscriptiondetails')),
            ],
        ),
        migrations.CreateModel(
            name='SubjectBasedSubscriptionkeys',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('key', models.CharField(blank=True, max_length=255, null=True, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('details', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='keys', to='subscription.subjectbasedsubscriptiondetails')),
            ],
        ),
    ]
