from django.urls import path
from . import views
from django.conf import settings
from django.conf.urls.static import static



urlpatterns = [
    path('doubts/', views.doubts_home, name='doubts_home'),
    path('get-subjects/', views.get_subjects, name='get_subjects'),
    path('get-chapters/', views.get_chapters, name='get_chapters'),
    path('post-doubt/', views.post_doubt, name='post_doubt'),
    path('like/<uuid:doubt_id>/', views.like_doubt, name='like_doubt'),
    path('bookmark/<uuid:doubt_id>/', views.bookmark_doubt, name='bookmark_doubt'),
    path('comment/<uuid:doubt_id>/', views.post_comment, name='post_comment'),
    path('my-doubts/', views.my_doubts, name='my_doubts'),
    path('my-bookmarks/', views.my_bookmarks, name='my_bookmarks'),
    path('comments/<uuid:doubt_id>/', views.get_comments, name='get_comments'),
    path('notifications/', views.notifications_view, name='notifications'),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT) + static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)