from .models import StudentProfile

def create_student_profile(strategy, details, backend, user, *args, **kwargs):
    """
    Pipeline function to create a corresponding StudentProfile when a new user
    is created via social login (e.g., Google). This will only run if `user`
    does not already have a StudentProfile.
    """
    # If the user already has a studentprofile, do nothing.
    if not hasattr(user, 'studentprofile'):
        StudentProfile.objects.create(user=user)
